'use strict';

/* --------------------------------------------------------------
 delete.js 2016-09-30
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Delete Invoice Modal Controller
 */
gx.controllers.module('delete', ['modal'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {
        bindings: {
            selectedInvoices: $this.find('.selected-invoice-ids')
        }
    };

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * Send the modal data to the form through an AJAX call.
     */
    function _onDeleteClick() {
        var url = jse.core.config.get('appUrl') + '/admin/admin.php?do=InvoicesModalsAjax/DeleteInvoice';
        var data = {
            selectedInvoices: module.bindings.selectedInvoices.get().split(','),
            pageToken: jse.core.config.get('pageToken')
        };
        var $deleteButton = $(this);

        $deleteButton.addClass('disabled').prop('disabled', true);

        $.ajax({
            url: url,
            data: data,
            method: 'POST',
            dataType: 'json'
        }).done(function (response) {
            jse.libs.info_box.addSuccessMessage(jse.core.lang.translate('DELETE_INVOICES_SUCCESS', 'admin_invoices'));
            $('.invoices .table-main').DataTable().ajax.reload(null, false);
            $('.invoices .table-main').invoices_overview_filter('reload');
        }).fail(function (jqxhr, textStatus, errorThrown) {
            jse.libs.modal.showMessage(jse.core.lang.translate('error', 'messages'), jse.core.lang.translate('DELETE_INVOICES_ERROR', 'admin_invoices'));
        }).always(function () {
            $this.modal('hide');
            $deleteButton.removeClass('disabled').prop('disabled', false);
        });
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('click', '.btn.delete', _onDeleteClick);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
